/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile;

import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.IContentsListener;
import mekanism.api.RelativeSide;
import mekanism.api.energy.IStrictEnergyHandler;
import mekanism.api.math.FloatingLong;
import mekanism.common.Mekanism;
import mekanism.common.capabilities.energy.MachineEnergyContainer;
import mekanism.common.capabilities.holder.energy.EnergyContainerHelper;
import mekanism.common.capabilities.holder.energy.IEnergyContainerHolder;
import mekanism.common.entity.EntityRobit;
import mekanism.common.integration.curios.CuriosIntegration;
import mekanism.common.integration.energy.EnergyCompatUtils;
import mekanism.common.registries.MekanismBlocks;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.util.MekanismUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class TileEntityChargepad
extends TileEntityMekanism {
    private static final Predicate<LivingEntity> CHARGE_PREDICATE = entity -> !entity.m_5833_() && (entity instanceof Player || entity instanceof EntityRobit);
    private MachineEnergyContainer<TileEntityChargepad> energyContainer;

    public TileEntityChargepad(BlockPos pos, BlockState state) {
        super(MekanismBlocks.CHARGEPAD, pos, state);
    }

    @Override
    @Nonnull
    protected IEnergyContainerHolder getInitialEnergyContainers(IContentsListener listener) {
        EnergyContainerHelper builder = EnergyContainerHelper.forSide(this::getDirection);
        this.energyContainer = MachineEnergyContainer.input(this, listener);
        builder.addContainer(this.energyContainer, RelativeSide.BACK, RelativeSide.BOTTOM);
        return builder.build();
    }

    @Override
    protected void onUpdateServer() {
        super.onUpdateServer();
        boolean active = false;
        List entities = this.f_58857_.m_6443_(LivingEntity.class, new AABB((double)this.f_58858_.m_123341_(), (double)this.f_58858_.m_123342_(), (double)this.f_58858_.m_123343_(), (double)(this.f_58858_.m_123341_() + 1), (double)this.f_58858_.m_123342_() + 0.4, (double)(this.f_58858_.m_123343_() + 1)), CHARGE_PREDICATE);
        for (LivingEntity entity : entities) {
            Optional itemHandlerCap;
            boolean bl = active = !this.energyContainer.isEmpty();
            if (!active) break;
            if (entity instanceof EntityRobit) {
                EntityRobit robit = (EntityRobit)entity;
                this.provideEnergy(robit);
                continue;
            }
            if (!(entity instanceof Player) || this.chargeHandler(itemHandlerCap = entity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).resolve()) || !Mekanism.hooks.CuriosLoaded) continue;
            this.chargeHandler(CuriosIntegration.getCuriosInventory(entity));
        }
        if (active != this.getActive()) {
            this.setActive(active);
        }
    }

    private boolean chargeHandler(Optional<? extends IItemHandler> itemHandlerCap) {
        if (itemHandlerCap.isPresent()) {
            IItemHandler itemHandler = itemHandlerCap.get();
            int slots = itemHandler.getSlots();
            for (int slot = 0; slot < slots; ++slot) {
                ItemStack stack = itemHandler.getStackInSlot(slot);
                if (stack.m_41619_() || !this.provideEnergy(EnergyCompatUtils.getStrictEnergyHandler(stack))) continue;
                return true;
            }
        }
        return false;
    }

    private boolean provideEnergy(@Nullable IStrictEnergyHandler energyHandler) {
        FloatingLong extractedEnergy;
        if (energyHandler == null) {
            return false;
        }
        FloatingLong energyToGive = this.energyContainer.getEnergyPerTick();
        FloatingLong simulatedRemainder = energyHandler.insertEnergy(energyToGive, Action.SIMULATE);
        if (simulatedRemainder.smallerThan(energyToGive) && !(extractedEnergy = this.energyContainer.extract(energyToGive.subtract(simulatedRemainder), Action.EXECUTE, AutomationType.INTERNAL)).isZero()) {
            MekanismUtils.logExpectedZero(energyHandler.insertEnergy(extractedEnergy, Action.EXECUTE));
            return true;
        }
        return false;
    }

    @Override
    protected void onUpdateClient() {
        super.onUpdateClient();
        if (this.getActive()) {
            this.f_58857_.m_7106_((ParticleOptions)DustParticleOptions.f_123656_, (double)this.m_58899_().m_123341_() + this.f_58857_.f_46441_.nextDouble(), (double)this.m_58899_().m_123342_() + 0.15, (double)this.m_58899_().m_123343_() + this.f_58857_.f_46441_.nextDouble(), 0.0, 0.0, 0.0);
        }
    }

    @Override
    public void setActive(boolean active) {
        boolean wasActive = this.getActive();
        super.setActive(active);
        if (wasActive != active) {
            float pitch;
            SoundEvent sound;
            if (active) {
                sound = SoundEvents.f_12449_;
                pitch = 0.8f;
            } else {
                sound = SoundEvents.f_12448_;
                pitch = 0.7f;
            }
            this.f_58857_.m_6263_(null, (double)this.m_58899_().m_123341_() + 0.5, (double)this.m_58899_().m_123342_() + 0.1, (double)this.m_58899_().m_123343_() + 0.5, sound, SoundSource.BLOCKS, 0.3f, pitch);
        }
    }
}

